<?php
  require("myumbc_xml.php");
  $group = "doit";
  // $spotlights = parse_xml($group, "spotlights", "");
  $news = parse_xml($group, "news", "?page=1&page_size=5&mode=recent");
  $events = parse_xml($group, "events", "?page=1&page_size=5&mode=recent");
  var_dump($events);
  exit;
?>

<html>

<head>
  <title>Spotlight Page</title>
  <script type="text/javascript" src="jquery-1.4.2.min.js"></script>
  <script type="text/javascript" src="spotlight.js"></script>
  <link rel="stylesheet" href="spotlight.css" type="text/css" />
</head>

<body>
<?php if ($spotlights) { ?>
  <div class="spotlight-widget">
    <div class="panels">
      <?php while(list($key,$val) = each($spotlights)): ?>
        <div class='panel panel-<?= $key ?>' style='background-image: url("<?= $spotlights[$key]["thumbnail"]["xxlarge"] ?>")'>
          <div class="content-details <?= $spotlights[$key]["caption_align"] ?>">
            <div class="title">
              <?= $spotlights[$key]["title"] ?>
            </div>
            <div class="tagline">
              <?= $spotlights[$key]["tagline"] ?>
            </div>
            <div class="description">
              <?= $spotlights[$key]["description"] ?>
            </div>            

            <?php if ($spotlights[$key]["website"] || $spotlights[$key]["attachment_url"]): ?>
              <div class="buttons">
                <?php if ($spotlights[$key]["website"]): ?>
                  <a class="button highlight" href="<?= $spotlights[$key]["website"] ?>">Visit Website</a>
                <?php endif; ?>
                <?php if ($spotlights[$key]["attachment_url"]): ?>
                  <a class="button highlight" href="<?= $spotlights[$key]["attachment_url"] ?>">Download <?= $spotlights[$key]["attachment_kind"] ?></a>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
    <div class="playlist-background"></div>
    <div class="playlist">
      <?php if ($more): ?>
        <div class="more">
          <a class="button highlight" href="http://my.umbc.edu/groups/myumbc/spotlights" title="View more spotlights">
            more &raquo;
          </a>
        </div>
      <?php endif; ?>
      <ul>
        <?php reset($spotlights); ?>
        <?php while(list($key,$val) = each($spotlights)): ?>
          <li class='item-<?= $key ?>'>
            <span class="thumbnail xxsmall" style='background-image: url("<?= $spotlights[$key]["thumbnail"]["xxsmall"] ?>")' title="<?= $spotlights[$key]["title"] ?>"></span>
          </li>
        <?php endwhile; ?>
       </ul> 
    </div>
  </div>
<?php } else { ?>
  <!-- Content when no spotlights are being pulled through myUMBC -->
<?php } ?>

<?php if ($news) { ?>
  <div id="news">
    <h3>Recent News</h3>
    <ul>
    <?php while(list($key,$val) = each($news)): ?>
      <li class='item-<?= $key ?>'>
        <div class="title"><a href="./news.php?id=<?= $news[$key]["id"] ?>"><?= $news[$key]["title"] ?></a></div>
        <div class="title">View in myUMBC:<a href="http://my.umbc.edu/groups/<?= $group ?>/news/<?= $news[$key]["id"] ?>">http://my.umbc.edu/groups/<?= $group ?>/news/<?= $news[$key]["id"] ?></a></div>
      </li>
    <?php endwhile; ?>
    </ul>
  </div>
<?php } else { ?>
  <!-- Content when no news is being pulled through myUMBC -->
<?php } ?>

<?php if ($events) { ?>
  <div id="events">
    <h3>Recent events</h3>
    <ul>
    <?php while(list($key,$val) = each($events)): ?>
      <li class='item-<?= $key ?>'>
        <div class="title"><a href="./events.php?id=<?= $events[$key]["id"] ?>"><?= $events[$key]["title"] ?></a></div>
        <div class="title">View in myUMBC: <a href="http://my.umbc.edu/groups/<?= $group ?>/events/<?= $events[$key]["id"] ?>">my.umbc.edu/groups/<?= $group ?>/events/<?= $events[$key]["id"] ?></a></div>
      </li>
    <?php endwhile; ?>
    </ul>
  </div>
<?php } else { ?>
<!-- Content when no events is being pulled through myUMBC -->
<?php } ?>


</body>

</html>